function [image,Original,Norm,Logbook,Count] = Artifacts(handles)
% Removes cosmic rays, etc from the data. By comparing the immediate
% surroundings with its standard deviation to the pixel iteself,
% outsiders above a certain threshold can be found and be replaced by the
% mean value of the sourrounding. As the normalized image is expected to be
% more homogenous, the processing is done to the normalized image. The
% sourrounding is defined as a 5x5 block of pixels in the same energy
% slice. The image boundaries are ignored.

global tracer

if isempty(tracer)
    tracer=1;
else
    image    = [];
    Original = [];
    Norm     = [];
    Logbook  = [];
    Count    = [];
    clearvars -except image Original Norm Logbook Count
    return
end

%% Load File
image      = load(fullfile(tempdir,'ShowOrg.mat')).image;
Original   = load(fullfile(tempdir,'Original.mat')).image;
Thres      = str2double(get(handles.Thres,'String'));
Logbook    = get(handles.Logbook,'UserData');
Cut        = get(handles.EstimatePhi,'UserData');
Drift      = get(handles.ShowDrift,'UserData');
EnergyRes  = get(handles.Slider, 'SliderStep');
EnergyRes  = EnergyRes(1);

%% Calculate
Drift      = Cut(1) + round(Drift./EnergyRes);
Norm       = sum(image,3);
image      = image./Norm;
Original   = Original./Norm;
Count      = 0;
WaitTics   = ceil(size(image,3));
WaitArt    = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);
tic;
SizeX      = size(image,2);
SizeY      = size(image,1);
SizeZ      = size(image,3);

for i=1:SizeZ
    img = reshape(image(:,:,i),[SizeY,SizeX]);
    if SizeX>1 && SizeY>1
        %% for the edges
        pixel      = img(1,1);
        Block      = img(1:2,1:2);
        Block(1,1) = 0;
        Block(1,1) = sum(Block,'all')/3;
        Mean       = Block(1,1);
        Std        = sqrt((std(Block,[],'all'))^2 *3/2);
        if abs(pixel-Mean)>Thres*Std
            Count                             = Count+1;
            img(1,1)                          = Mean;
            Original(1,1,i+Drift(1,1))        = Mean;
        end
        pixel      = img(1,SizeX);
        Block      = img(1:2,SizeX-1:SizeX);
        Block(1,2) = 0;
        Block(1,2) = sum(Block,'all')/3;
        Mean       = Block(1,2);
        Std        = sqrt((std(Block,[],'all'))^2 *3/2);
        if abs(pixel-Mean)>Thres*Std
            Count                              = Count+1;
            img(1,SizeX)                       = Mean;
            Original(1,SizeX,i+Drift(1,SizeX)) = Mean;
        end
        pixel      = img(SizeY,1);
        Block      = img(SizeY-1:SizeY,1:2);
        Block(2,1) = 0;
        Block(2,1) = sum(Block,'all')/3;
        Mean       = Block(1,2);
        Std        = sqrt((std(Block,[],'all'))^2 *3/2);
        if abs(pixel-Mean)>Thres*Std
            Count                              = Count+1;
            img(SizeY,1)                       = Mean;
            Original(SizeY,1,i+Drift(SizeY,1)) = Mean;
        end
        pixel      = img(SizeY,SizeX);
        Block      = img(SizeY-1:SizeY,SizeX-1:SizeX);
        Block(2,2) = 0;
        Block(2,2) = sum(Block,'all')/3;
        Mean       = Block(2,2);
        Std        = sqrt((std(Block,[],'all'))^2 *3/2);
        if abs(pixel-Mean)>Thres*Std
            Count                                      = Count+1;
            img(SizeY,SizeX)                           = Mean;
            Original(SizeY,SizeX,i+Drift(SizeY,SizeX)) = Mean;
        end
        %% for the first rows
        k=1;
        for j = 2:SizeY-1
            pixel      = img(j,k);
            Block      = img((j-1):(j+1),k:(k+1));
            Block(2,1) = 0;
            Block(2,1) = sum(Block,'all')/5;
            Mean       = Block(2,1);
            Std        = sqrt((std(Block,[],'all'))^2 *5/4);
            if abs(pixel-Mean)>Thres*Std
                Count                      = Count+1;
                img(j,k)                   = Mean;
                Original(j,k,i+Drift(j,k)) = Mean;
            end
        end
        
        k=SizeX;
        for j = 2:SizeY-1
            pixel      = img(j,k);
            Block      = img((j-1):(j+1),(k-1):k);
            Block(2,2) = 0;
            Block(2,2) = sum(Block,'all')/5;
            Mean       = Block(2,2);
            Std        = sqrt((std(Block,[],'all'))^2 *5/4);
            if abs(pixel-Mean)>Thres*Std
                Count                      = Count+1;
                img(j,k)                   = Mean;
                Original(j,k,i+Drift(j,k)) = Mean;
            end
        end
        
        j=1;
        for k = 2:SizeX-1
            pixel      = img(j,k);
            Block      = img(j:(j+1),(k-1):(k+1));
            Block(1,2) = 0;
            Block(1,2) = sum(Block,'all')/5;
            Mean       = Block(1,2);
            Std        = sqrt((std(Block,[],'all'))^2 *5/4);
            if abs(pixel-Mean)>Thres*Std
                Count                      = Count+1;
                img(j,k)                   = Mean;
                Original(j,k,i+Drift(j,k)) = Mean;
            end
        end
        
        j=SizeY;
        for k = 2:SizeX-1
            pixel      = img(j,k);
            Block      = img((j-1):j,(k-1):(k+1));
            Block(2,2) = 0;
            Block(2,2) = sum(Block,'all')/5;
            Mean       = Block(2,2);
            Std        = sqrt((std(Block,[],'all'))^2 *5/4);
            if abs(pixel-Mean)>Thres*Std
                Count                      = Count+1;
                img(j,k)                   = Mean;
                Original(j,k,i+Drift(j,k)) = Mean;
            end
        end
    end
    
    if SizeX>=5 && SizeY>=5
        %% for the second rows
        
        for j = [2, SizeY-1]
            for k=2:SizeX-1
                pixel      = img(j,k);
                Block      = img((j-1):(j+1),(k-1):(k+1));
                Block(2,2) = 0;
                Block(2,2) = sum(Block,'all')/8;
                Mean       = Block(2,2);
                Std        = sqrt((std(Block,[],'all'))^2 *8/7);
                if abs(pixel-Mean)>Thres*Std
                    Count                      = Count+1;
                    img(j,k)                   = Mean;
                    Original(j,k,i+Drift(j,k)) = Mean;
                end
            end
        end
        
        for j = 3:SizeY-2
            for k = [2, SizeX-1]
                pixel      = img(j,k);
                Block      = img((j-1):(j+1),(k-1):(k+1));
                Block(2,2) = 0;
                Block(2,2) = sum(Block,'all')/8;
                Mean       = Block(2,2);
                Std        = sqrt((std(Block,[],'all'))^2 *8/7);
                if abs(pixel-Mean)>Thres*Std
                    Count                      = Count+1;
                    img(j,k)                   = Mean;
                    Original(j,k,i+Drift(j,k)) = Mean;
                end
            end
        end
        
        %% for the inner rows
        for j = 3:SizeY-2
            for k = 3:SizeX-2
                pixel      = img(j,k);
                Block      = img((j-2):(j+2),(k-2):(k+2));
                Block(3,3) = 0;
                Block(3,3) = sum(Block,'all')/24;
                Mean       = Block(3,3);
                Std        = sqrt((std(Block,[],'all'))^2 *24/23);
                if abs(pixel-Mean)>Thres*Std
                    Count                      = Count+1;
                    img(j,k)                   = Mean;
                    Original(j,k,i+Drift(j,k)) = Mean;
                    
                end
            end
        end
    elseif SizeX>=3 && SizeY>=3
        %% for the inner rows
        for j = 2:SizeY-1
            for k = 2:SizeX-1
                pixel      = img(j,k);
                Block      = img((j-1):(j+1),(k-1):(k+1));
                Block(2,2) = 0;
                Block(2,2) = sum(Block,'all')/8;
                Mean       = Block(3,3);
                Std        = sqrt((std(Block,[],'all'))^2 *8/7);
                if abs(pixel-Mean)>Thres*Std
                    Count                      = Count+1;
                    img(j,k)                   = Mean;
                    Original(j,k,i+Drift(j,k)) = Mean;

                end
            end
        end
    end
    image(:,:,i)=img;
    
    %% Check Waitbar exist
    Flag = CheckWaitbar1(WaitArt);
    if Flag==1
        image    = [];
        Original = [];
        Norm     = [];
        Logbook  = [];
        Count    = [];
        clearvars -except image Original Norm Logbook Count
        return
    end
    WaitArt.Send;
    
end
WaitArt.Destroy;
toc;

image    = image.*   Norm;
Original = Original.*Norm; 
Norm     = sum(image,3);

%% Create Logbook entry
Logbook{end+1} = ['RemArtifacts:  Thres: ',num2str(Thres),'  |  Removed Artifacts: ',num2str(Count)];

clearvars -except image Original Norm Logbook Count
end